unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
function Potencia(base,expoente : Double) : Double;
begin
  if base = 0 then
    Result := 0
  else if base < 0 then
    Result := exp(ln(-base)*expoente)
  else  
    Result := exp(ln(base)*expoente);
end;

function tan(x : Double) : Double;
begin
  Result := sin(x)/cos(x);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (Edit1.Text <> '') and (Edit2.Text <> '') then
  try
    ShowMessage(FloatToStr(Potencia(StrToFloat(Edit1.Text),StrToFloat(Edit2.Text))));
  except
    On EConvertError do
      MessageDlg('Nmero Invlido', mtError, [mbOk], 0);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if (Edit1.Text <> '') then
  try
    ShowMessage(FloatToStr(Tan(StrToFloat(Edit1.Text))));
  except
    On EConvertError do
      MessageDlg('Nmero Invlido', mtError, [mbOk], 0);
  end;
end;

end.
